#ifndef PARSER_ATP_SST_UTILS_H
#define PARSER_ATP_SST_UTILS_H


#include "msg_defs.h"
#include "SST_SEP_TST.h"
#include "sst_errors.h"
#include "sst_sep_errors.h"
/*****************************************************************************
* Function Name:
*  DX_SEP_PARSER_SST_Utility_Handle
*  
* Inputs:
*  msg - message with all requested parameters.
*
* Outputs: 
*  DxUint32_t - Function error return
*
* Description:
* This function does the parsing for the external application 
* of the insertion, generation, reading, deletion, and usage of an AES symmetric key.
*
* It calls the SEP function with parameters parsed from input message
* Algorithm: 
* 1. call to DX_SEP_MNG_SSTGetWorkspaceParams
* 2. allocate memory for GlobalMemBuff for all next needed allocation in the test
* 3. allocate buffer from GlobalMemBuff to data struct
* 4. extract parameters from the message 
* 5. call QA SEP function
* 6. free allocated GlobalMemBuff
* 7. end SEP message and return
******************************************************************************/

DxUint32_t DX_SEP_PARSER_SST_Utility_Handle(DxUint32_t* msg);
/*****************************************************************************
* Function Name:
*  DX_SEP_SST_PARSER_Utility_Size
*  
* Inputs:
*  msg - message with all requested parameters.
*
* Outputs: 
*  DxUint32_t - Function error return
*
* Description:
* This function does the parsing for the external application 
* of the insertion, generation, reading, deletion, and usage of an AES symmetric key.
*
* It calls the SEP function with parameters parsed from input message
* Algorithm: 
* 1. call to DX_SEP_MNG_SSTGetWorkspaceParams
* 2. allocate memory for GlobalMemBuff for all next needed allocation in the test
* 3. allocate buffer from GlobalMemBuff to data struct
* 4. extract parameters from the message 
* 5. call QA SEP function
* 6. free allocated GlobalMemBuff
* 7. end SEP message and return
******************************************************************************/

DxUint32_t DX_SEP_SST_PARSER_Utility_Size(DxUint32_t* msg);
#endif